import pygame
import random

from OpenGL.GL import *
from OpenGL.GLU import *

class Star:
  def __init__(self,r,g,b,dist,angle,li):
    self.li = li
    self.col = [r,g,b]
    self.dist = dist
    self.angle = angle
  def prevstar(self):
    i = self.li.index(self)
    i -= 1
    if i<0: i=len(self.li)-1
    return self.li[i]
  def draw(self,zoom,tilt,spin,twinkle):
    glLoadIdentity()
    glTranslatef(0,0,zoom)
    #rotate to position the star out from center at some point
    glRotatef(tilt,1,0,0)
    glRotatef(self.angle,0,1,0)
    #move star out along our new axis line - who knows where it is
    glTranslatef(self.dist,0,0)
    #rotate star back so its facing forward again
    glRotatef(-self.angle,0,1,0)
    glRotatef(-tilt,1,0,0)
    if twinkle:
      #draw prev star color star behind us
      ps = self.prevstar()
      glColor4ub(ps.col[0],ps.col[1],ps.col[2],255)
      glBegin(GL_QUADS)
      glTexCoord2f(0,0);glVertex3f(-1,-1,0)
      glTexCoord2f(1,0);glVertex3f(1,-1,0)
      glTexCoord2f(1,1);glVertex3f(1,1,0)
      glTexCoord2f(0,1);glVertex3f(-1,1,0)
      glEnd()
    glRotatef(spin,0,0,1)
    #draw main star
    glColor4ub(int(self.col[0]),int(self.col[1]),int(self.col[2]),255)
    glBegin(GL_QUADS)
    glTexCoord2f(0,0);glVertex3f(-1,-1,0)
    glTexCoord2f(1,0);glVertex3f(1,-1,0)
    glTexCoord2f(1,1);glVertex3f(1,1,0)
    glTexCoord2f(0,1);glVertex3f(-1,1,0)
    glEnd()

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 9 - b+w textures, moving bitmap, alpha masks"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    self.lighting = False
    self.ambientlight = (.5,.5,.5,1)  #halfbright
    self.diffuselight = (1,1,1,1)  #fullbright
    self.lightpos = (0,0,2,1)   #a little in front of screen
    
    #instance variables to be replaced with objects
    self.twinkle = False
    self.stars = []
    self.z = -15
    self.tilt = 90
    self.spin = 0
    
    self.filter = 0 #which texture to use
  def initGL(self):
    if not self.texloaded: self.loadGLTextures()
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    #glEnable(GL_DEPTH_TEST)
    #glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    glLightfv(GL_LIGHT1,GL_AMBIENT,self.ambientlight)
    glLightfv(GL_LIGHT1,GL_DIFFUSE,self.diffuselight)
    glLightfv(GL_LIGHT1,GL_POSITION,self.lightpos)
    glEnable(GL_LIGHT1)
    #blending color
    glEnable(GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA,GL_ONE)
    for i in range(50):  #make 50 stars
      s = Star(random.random()*256,random.random()*256,random.random()*256,float(i)/50.*5.0,0,self.stars)
      self.stars.append(s)
    #self.glinited = True
  def loadGLTextures(self):
    self.textures.append(pygame.image.load("Data/Star.bmp"))
    idat = pygame.image.tostring(self.textures[0],"RGB",True)
    self.tnames = glGenTextures(1)
    if not hasattr(self.tnames,"__len__"):
      self.tnames = (self.tnames,)
    #linear filter
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    glTexImage2D(GL_TEXTURE_2D,0,3,self.textures[0].get_width(),self.textures[0].get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
    #self.texloaded = True
    self.textures = []
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    for i in range(len(self.stars)):
      s = self.stars[i]
      s.draw(self.z,self.tilt,self.spin,self.twinkle)
      self.spin += 0.01
      s.angle += float(i)/len(self.stars)
      s.dist-=.01
      if s.dist<0:
        s.dist+=5
        s.col[0] = random.random()*256
        s.col[1] = random.random()*256
        s.col[2] = random.random()*256

screen = Screen()
screen.resize()

running = 1
while running:
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
      if e.key==pygame.K_l:
        screen.lighting = not screen.lighting
        if screen.lighting:
          glEnable(GL_LIGHTING)
        else:
          glDisable(GL_LIGHTING)
      if e.key==pygame.K_f:
        screen.filter += 1
        if screen.filter>2:
          screen.filter=0
  keys = pygame.key.get_pressed()
  if keys[pygame.K_PAGEUP]:
    screen.z += .02
  if keys[pygame.K_PAGEDOWN]:
    screen.z -= .02
  if keys[pygame.K_RIGHT]:
    pass
  if keys[pygame.K_LEFT]:
    pass
  if keys[pygame.K_UP]:
    screen.tilt-=.5
  if keys[pygame.K_DOWN]:
    screen.tilt+=.5
